-- events for main menu


function OnLoad ()
	SetProperty ("/:enter_trans_duration", 0.3);
	SetProperty ("/:leave_trans_duration", 0.3);
	CacheSound ("ui/sfx/panel_move.ogg");
end;


function OnEnter ()
	SetProperty ("VolSound:slider.value", GetVar ("SoundVolume"));
	SetProperty ("VolMusic:slider.value", GetVar ("MusicVolume"));
	SetProperty ("Fullscreen:checkbox.value", 1-GetVar ("ScreenWindowed"));
	PlaySound ("ui/sfx/panel_move.ogg");
end;

function OnLeave ()
    
end;


function OnClick (name)

	Print ("OnClick " .. name .. "\n");
	
	if (name == "Ok") then
	    PlaySound ("ui/sfx/panel_move.ogg");
		PopScreen ("Options");
		return;
	end;
	
	if (name == "Credits") then
		PushScreen ("Credits");
		return;
	end;
	
	if (name == "VolSound") then
		PlaySound ("ui/sfx/sound-check.ogg");
	end;

	if (name == "Fullscreen") then
		-- toggle the checkbox value
		new_value = 1-GetProperty ("Fullscreen:checkbox.value");
		Print ("New value " .. new_value .. " \n");
		SetProperty ("Fullscreen:checkbox.value", new_value);
		SetVar ("ScreenWindowed", 1-new_value); -- flip this again..
		NexusReInit ();
	end;
end;


function OnUpdate (tdelta)

	akey = GetActiveScreenAnimKey ();

	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	SetProperty ("panel:position_offset.y", (1-trans) * 200);
	SetProperty ("panel:alpha", trans);
	SetProperty ("fader:alpha", trans + trans * 0.05 * math.sin (2*3.141592*akey));
	SetProperty ("Fullscreen:checkbox.value", 1-GetVar ("ScreenWindowed"));	-- music volume can be updated constantly	
	SetMusicVolume (GetProperty ("VolMusic:slider.value"));
	SetSoundVolume (GetProperty ("VolSound:slider.value"));
end;

function OnDraw ()

end;
